# Области видимости имен
Область видимости определяет, к каким переменным можно получить доступ и откуда. По сути, она сопоставляет имена со значениями.
Область видимости действует в игре практически так же, как и в Python.

Существует глобальная область видимости, а у каждой функции есть своя локальная область видимости.
Когда ты определяешь переменную, она добавляется в текущую область видимости.
Все, что находится вне определения функции, считается частью глобальной области видимости.

`x = 1`
Присваивает значение `1` имени `x` в глобальной области видимости.

Эта инструкция `def` присваивает функцию имени `f` в глобальной области видимости.
`def f():
    `Присваивает значение `1` имени `y` в локальной области видимости `f`.`
    y = 1

    `Присваивает функцию имени `g` в локальной области видимости `f`.`
    def g():
        pass`

`f()`
Извлекает функцию, хранящуюся в `f` из глобальной области видимости, и вызывает ее.

`print(y)`
Эта инструкция вывода в глобальной области видимости вызывает ошибку, поскольку `y` никогда не объявлялась в глобальной области видимости и мы не можем ее здесь прочитать.
Она существовала только в локальной области видимости `f`.

## Ключевое слово global
По умолчанию все переменные в функциях привязываются к локальной области видимости, даже если переменная с таким же именем существует в глобальной области видимости.

`x = 0

def f():
    x = 1
f()
print(x)`

Этот код выводит `0`, потому что локальная `x` внутри `f` — это не та же переменная, что и глобальная `x`, и глобальная `x` остается неизменной. Это важно, потому что в противном случае вызов функции мог бы случайно перезаписать глобальную переменную с тем же именем, что и локальная переменная функции.

Если ты хочешь записать значение в глобальную переменную, это нужно специально указать, используя ключевое слово `global`.

`x = 0

def f():
    global x
    x = 1
f()
print(x)`

В этом примере `global x` привязывает `x` к глобальной переменной `x`, определенной выше. Теперь будет выведено `1`.
Обрати внимание, что изменение глобальных переменных зачастую первый шаг к получению спагетти-кода, где каждая часть программы влияет на какую-то другую часть программы. Этим лучше не злоупотреблять.

## Циклы и ветвления
Циклы и ветвления не создают собственных областей видимости, поэтому все, что объявлено в них, можно использовать за их пределами.

`for i in range(3):
    pass
print(i)`

Такой код выведет `2`, потому что последняя итерация цикла `for` присвоила `2` переменной `i`.